<?php $__env->startSection('content'); ?>
<div class="container py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-2xl font-bold">Shipments</h1>
        <a href="<?php echo e(route('admin.shipments.create')); ?>" class="bg-primary text-white px-4 py-2 rounded">Create Shipment</a>
    </div>
    <?php if(session('success')): ?>
        <div class="bg-green-100 text-green-800 p-3 rounded mb-4"><?php echo e(session('success')); ?></div>
    <?php endif; ?>
    <div class="overflow-x-auto">
        <table class="min-w-full bg-white border">
            <thead>
                <tr>
                    <th class="px-4 py-2 border">Tracking #</th>
                    <th class="px-4 py-2 border">Sender</th>
                    <th class="px-4 py-2 border">Receiver</th>
                    <th class="px-4 py-2 border">Status</th>
                    <th class="px-4 py-2 border">Shipped</th>
                    <th class="px-4 py-2 border">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="border px-4 py-2"><?php echo e($shipment->trackingnumber); ?></td>
                    <td class="border px-4 py-2"><?php echo e($shipment->sender_name); ?></td>
                    <td class="border px-4 py-2"><?php echo e($shipment->receiver_name); ?></td>
                    <td class="border px-4 py-2"><?php echo e($shipment->status); ?></td>
                    <td class="border px-4 py-2"><?php echo e($shipment->date_shipped); ?></td>
                    <td class="border px-4 py-2">
                        <a href="<?php echo e(route('admin.shipments.show', $shipment->id)); ?>" class="text-blue-600">View</a> |
                        <a href="<?php echo e(route('admin.shipments.edit', $shipment->id)); ?>" class="text-yellow-600">Edit</a> |
                        <a href="<?php echo e(route('admin.shipments.updateform', $shipment->id)); ?>" class="text-green-600">Update Status</a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <div class="mt-4">
        <?php echo e($shipments->links()); ?>

    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\remedytracking\resources\views/admin/shipments/index.blade.php ENDPATH**/ ?>