@extends('layouts.base')
@inject('content', 'App\Http\Controllers\FrontController')

@section('styles')
@parent
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    /* Force Font Awesome icons to always display */
    .fas, .fab, .far, .fa, .fa-icon {
        display: inline-block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }

    /* Make sure icons on primary backgrounds are visible */
    .bg-primary .fas,
    .bg-primary .fab,
    .bg-primary .far,
    .bg-primary .fa,
    .bg-primary-light .fas,
    [class*="bg-primary"] [class*="text-primary"] {
        color: white !important;
    }

    /* Tracking progress bar */
    .track-line {
        height: 5px;
        background-color: #e5e7eb;
        border-radius: 999px;
        position: relative;
        overflow: hidden;
    }

    .track-line-progress {
        height: 100%;
        background-color: var(--primary-color);
        border-radius: 999px;
        position: absolute;
        top: 0;
        left: 0;
        transition: width 1s ease;
    }

    /* Timeline styles */
    .timeline-container {
        position: relative;
    }

    .timeline-connector {
        position: absolute;
        left: 15px;
        top: 40px;
        bottom: 0;
        width: 2px;
        background-color: var(--primary-color);
    }

    .timeline-dot {
        width: 32px;
        height: 32px;
        background-color: var(--primary-color);
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 10;
        position: relative;
    }

    .timeline-dot.delivered {
        background-color: var(--success-color);
    }

    .timeline-dot.in-transit {
        background-color: var(--warning-color);
    }

    /* Print button pulse animation */
    @keyframes pulse {
        0%, 100% {
            box-shadow: 0 0 0 0 rgba(255, 77, 0, 0.7);
        }
        50% {
            box-shadow: 0 0 0 10px rgba(255, 77, 0, 0);
        }
    }

    .pulse-button {
        animation: pulse 2s infinite;
    }

    /* Table styles */
    .tracking-table th {
        background-color: var(--secondary-color);
        color: white;
        font-weight: 600;
        padding: 1rem;
    }

    .tracking-table td {
        padding: 1rem;
    }

    .tracking-table tr:nth-child(odd) td {
        background-color: #f9fafb;
    }

    .tracking-table tr:nth-child(even) td {
        background-color: #f3f4f6;
    }
</style>
@endsection

@section('content')
<!-- Page Header -->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Tracking Results</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Home</a>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chevron-right w-4 h-4 mx-1 text-white"></i>
                        <a href="track-order" class="hover:text-primary transition-all">Track Order</a>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chevron-right w-4 h-4 mx-1 text-white"></i>
                        <span class="text-white">{{ $courier->trackingnumber }}</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<!-- Tracking Result Section -->
<section class="py-12 bg-white" x-data="{ activeTab: 'details' }" x-cloak>
    <div class="container mx-auto px-4">
        <div class="max-w-5xl mx-auto">
            <div class="flex flex-col md:flex-row items-start gap-6">
                <!-- Left Side - Main Information -->
                <div class="w-full md:w-7/12 lg:w-8/12">
                    <!-- Tracking Header -->
                    <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-6">
                        <div class="p-6 border-b border-gray-200">
                            <div class="flex flex-col md:flex-row md:items-center md:justify-between">
                                <div>
                                    <h2 class="text-2xl font-bold text-secondary">Shipment Tracking</h2>
                                    <p class="text-gray-600 mt-1">Tracking Number: <span class="font-semibold">{{ $courier->trackingnumber }}</span></p>
                                </div>
                                <div class="mt-4 md:mt-0">
                                    <a href="{{ route('printnow', $courier->id) }}" class="bg-primary hover:bg-secondary text-white py-2 px-4 rounded-lg flex items-center pulse-button transition duration-300">
                                        <i class="fas fa-print mr-2 text-white"></i>
                                        Print Invoice
                                    </a>
                                </div>
                            </div>
                        </div>

                        <div class="p-6">
                            <!-- Shipment Status -->
                            <div class="mb-8">
                                <div class="flex justify-between items-center mb-2">
                                    <h3 class="text-lg font-semibold text-secondary">Shipment Status</h3>
                                    <span class="px-3 py-1 rounded-full text-sm font-medium
                                        @if($courier->status == 'Delivered') bg-green-100 text-green-800
                                        @elseif($courier->status == 'In Transit') bg-yellow-100 text-yellow-800
                                        @elseif($courier->status == 'Pending') bg-blue-100 text-blue-800
                                        @else bg-gray-100 text-gray-800 @endif">
                                        {{ $courier->status }}
                                    </span>
                                </div>

                                <div class="bg-gray-100 p-4 rounded-lg">
                                    <div class="flex flex-col sm:flex-row sm:items-center justify-between mb-4">
                                        <div>
                                            <span class="text-sm text-gray-500">Delivery Progress</span>
                                            <div class="flex items-center">
                                                <span class="font-bold text-secondary text-lg">{{ $courier->percentage_complete }}%</span>
                                                <span class="text-sm text-gray-500 ml-2">Complete</span>
                                            </div>
                                        </div>
                                        <div class="mt-2 sm:mt-0">
                                            <span class="text-sm text-gray-500">Expected Delivery Date</span>
                                            <div class="font-semibold text-secondary">
                                                {{ \Carbon\Carbon::parse($courier->expected_delivery)->format('M d, Y') }}
                                            </div>
                                        </div>
                                    </div>

                                    <div class="track-line">
                                        <div class="track-line-progress" style="width: {{ $courier->percentage_complete }}%"></div>
                                    </div>
                                </div>
                            </div>

                            <!-- Barcode -->
                            <div class="flex justify-center mb-8">
                                <div class="text-center">
                                    <img src="https://barcode.tec-it.com/barcode.ashx?data={{ $courier->trackingnumber }}&code=Code128" alt="{{ $courier->trackingnumber }}" class="mx-auto mb-2">
                                    <span class="text-sm text-gray-500">{{ $courier->trackingnumber }}</span>
                                </div>
                            </div>

                            <!-- Package Image if available -->
                            @if($courier->photo != Null)
                            <div class="mb-8">
                                <h3 class="text-lg font-semibold text-secondary mb-3">Package Image</h3>
                                <div class="rounded-lg overflow-hidden border border-gray-200">
                                    <img src="{{ asset('storage/app/public/photos/' . $courier->photo) }}" alt="Package Image" class="w-full h-auto object-cover">
                                </div>
                            </div>
                            @endif

                            <!-- Tabs -->
                            <div class="border-b border-gray-200 mb-6">
                                <ul class="flex flex-wrap -mb-px">
                                    <li class="mr-2">
                                        <button @click="activeTab = 'details'" :class="{'border-primary text-primary': activeTab === 'details', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'details'}" class="inline-block py-4 px-4 font-medium text-center border-b-2">
                                            Shipment Details
                                        </button>
                                    </li>
                                    <li class="mr-2">
                                        <button @click="activeTab = 'history'" :class="{'border-primary text-primary': activeTab === 'history', 'border-transparent text-gray-500 hover:text-gray-700 hover:border-gray-300': activeTab !== 'history'}" class="inline-block py-4 px-4 font-medium text-center border-b-2">
                                            Tracking History
                                        </button>
                                    </li>
                                </ul>
                            </div>

                            <!-- Tab Content -->
                            <div>
                                <!-- Shipment Details Tab -->
                                <div x-show="activeTab === 'details'">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                        <!-- Origin & Destination -->
                                        <div class="bg-gray-50 rounded-lg p-4">
                                            <h4 class="text-sm uppercase font-semibold text-gray-500 mb-3">Shipment Route</h4>
                                            <div class="flex items-start">
                                                <div class="flex-shrink-0 mr-4">
                                                    <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center">
                                                        <i class="fas fa-plane-departure text-blue-600"></i>
                                                    </div>
                                                </div>
                                                <div>
                                                    <p class="font-semibold text-secondary">Origin</p>
                                                    <p class="text-gray-600">{{ $courier->take_off_point }}</p>
                                                </div>
                                            </div>

                                            <div class="w-px h-6 bg-gray-300 ml-5 my-1"></div>

                                            <div class="flex items-start">
                                                <div class="flex-shrink-0 mr-4">
                                                    <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center">
                                                        <i class="fas fa-plane-arrival text-green-600"></i>
                                                    </div>
                                                </div>
                                                <div>
                                                    <p class="font-semibold text-secondary">Destination</p>
                                                    <p class="text-gray-600">{{ $courier->final_destination }}</p>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Shipment Information -->
                                        <div class="bg-gray-50 rounded-lg p-4">
                                            <h4 class="text-sm uppercase font-semibold text-gray-500 mb-3">Shipment Information</h4>
                                            <ul class="space-y-2">
                                                <li class="flex justify-between">
                                                    <span class="text-gray-600">Service Type:</span>
                                                    <span class="font-medium">{{ $courier->shipment_type }}</span>
                                                </li>
                                                <li class="flex justify-between">
                                                    <span class="text-gray-600">Delivery Mode:</span>
                                                    <span class="font-medium">{{ $courier->freight_type }}</span>
                                                </li>
                                                <li class="flex justify-between">
                                                    <span class="text-gray-600">Package Weight:</span>
                                                    <span class="font-medium">{{ $courier->weight }}</span>
                                                </li>
                                                <li class="flex justify-between">
                                                    <span class="text-gray-600">Date Shipped:</span>
                                                    <span class="font-medium">{{ \Carbon\Carbon::parse($courier->date_shipped)->format('M d, Y') }}</span>
                                                </li>
                                            </ul>
                                        </div>

                                        <!-- Sender Information -->
                                        <div class="bg-gray-50 rounded-lg p-4">
                                            <h4 class="text-sm uppercase font-semibold text-gray-500 mb-3">Sender Information</h4>
                                            <div class="space-y-3">
                                                <div>
                                                    <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Name</span>
                                                    <p class="text-gray-800 font-medium mt-1">{{ $courier->sname }}</p>
                                                </div>
                                                <div>
                                                    <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Address</span>
                                                    <p class="text-gray-800 mt-1 leading-relaxed">{{ $courier->saddress }}</p>
                                                </div>
                                                <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                                    <div>
                                                        <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Email</span>
                                                        <p class="text-gray-800 mt-1 break-all">{{ $courier->semail }}</p>
                                                    </div>
                                                    <div>
                                                        <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Phone</span>
                                                        <p class="text-gray-800 mt-1">{{ $courier->sphone }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Receiver Information -->
                                        <div class="bg-gray-50 rounded-lg p-4">
                                            <h4 class="text-sm uppercase font-semibold text-gray-500 mb-3">Receiver Information</h4>
                                            <div class="space-y-3">
                                                <div>
                                                    <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Name</span>
                                                    <p class="text-gray-800 font-medium mt-1">{{ $courier->name }}</p>
                                                </div>
                                                <div>
                                                    <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Address</span>
                                                    <p class="text-gray-800 mt-1 leading-relaxed">{{ $courier->address }}</p>
                                                </div>
                                                <div class="grid grid-cols-1 sm:grid-cols-2 gap-3">
                                                    <div>
                                                        <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Email</span>
                                                        <p class="text-gray-800 mt-1 break-all">{{ $courier->email }}</p>
                                                    </div>
                                                    <div>
                                                        <span class="text-xs uppercase tracking-wide text-gray-500 font-medium">Phone</span>
                                                        <p class="text-gray-800 mt-1">{{ $courier->phone }}</p>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Shipment Description -->
                                    <div class="bg-gray-50 rounded-lg p-4 mt-6">
                                        <h4 class="text-sm uppercase font-semibold text-gray-500 mb-3">Shipment Description</h4>
                                        <p class="text-gray-600">{{ $courier->description }}</p>
                                    </div>
                                </div>

                                <!-- Tracking History Tab -->
                                <div x-show="activeTab === 'history'" x-cloak>
                                    @if(count($tracks) > 0)
                                    <div class="timeline-container">
                                        <div class="timeline-connector"></div>
                                        @foreach($tracks as $track)
                                        <div class="flex mb-6 relative">
                                            <div class="timeline-dot
                                                @if($track->status == 'Delivered') delivered
                                                @elseif($track->status == 'In Transit') in-transit @endif">
                                                <i class="fas
                                                    @if($track->status == 'Delivered') fa-check
                                                    @elseif($track->status == 'In Transit') fa-truck
                                                    @elseif($track->status == 'Processing') fa-cog
                                                    @elseif($track->status == 'Pending') fa-clock
                                                    @else fa-box @endif text-white"></i>
                                            </div>
                                            <div class="ml-4 flex-grow">
                                                <div class="bg-gray-50 rounded-lg p-4">
                                                    <div class="flex flex-col sm:flex-row sm:justify-between sm:items-center mb-1">
                                                        <h4 class="font-semibold text-secondary">{{ $track->status }}</h4>
                                                        <span class="text-sm text-gray-500">{{ \Carbon\Carbon::parse($track->created_at)->format('M d, Y h:i A') }}</span>
                                                    </div>
                                                    <p class="text-sm text-gray-600 mb-2">{{ $track->address }}, {{ $track->city }}, {{ $track->country }}</p>
                                                    @if($track->comment)
                                                    <p class="text-sm text-gray-600 border-t border-gray-200 pt-2 mt-2">{{ $track->comment }}</p>
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                    @else
                                    <div class="bg-yellow-50 border-l-4 border-yellow-400 p-4">
                                        <div class="flex">
                                            <div class="flex-shrink-0">
                                                <i class="fas fa-exclamation-circle text-yellow-400"></i>
                                            </div>
                                            <div class="ml-3">
                                                <p class="text-sm text-yellow-700">
                                                    No tracking history is available for this shipment yet.
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    @endif

                                    @isset($latesttrack->comment)
                                    <div class="bg-blue-50 border-l-4 border-blue-400 p-4 mt-6">
                                        <div class="flex">
                                            <div class="flex-shrink-0">
                                                <i class="fas fa-info-circle text-blue-400"></i>
                                            </div>
                                            <div class="ml-3">
                                                <p class="text-sm text-blue-700">
                                                    <span class="font-semibold">Notice:</span> {{ $latesttrack->comment }}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                    @endisset
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Right Side - Map and Actions -->
                <div class="w-full md:w-5/12 lg:w-4/12">
                    <!-- Map Card -->
                    <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-6">
                        <div class="p-4 bg-gray-50 border-b border-gray-200">
                            <h3 class="text-lg font-semibold text-secondary">Current Location</h3>
                        </div>
                        <div class="aspect-w-16 aspect-h-12">
                            <iframe class="w-full h-64 border-0" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q={{ $courier->location }}&t=m&z=13&ie=UTF8&iwloc=&output=embed"></iframe>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="bg-white rounded-lg shadow-lg overflow-hidden mb-6">
                        <div class="p-4 bg-gray-50 border-b border-gray-200">
                            <h3 class="text-lg font-semibold text-secondary">Quick Actions</h3>
                        </div>
                        <div class="p-4">
                            <div class="flex flex-col space-y-3">
                                <a href="{{ route('printnow', $courier->id) }}" class="flex items-center p-3 bg-gray-50 hover:bg-gray-100 rounded-lg transition duration-300">
                                    <div class="w-10 h-10 rounded-full bg-primary bg-opacity-10 flex items-center justify-center mr-3">
                                        <i class="fas fa-print text-white"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-medium text-secondary">Print Invoice</h4>
                                        <p class="text-sm text-gray-500">Get a printable invoice</p>
                                    </div>
                                </a>

                                <a href="contact" class="flex items-center p-3 bg-gray-50 hover:bg-gray-100 rounded-lg transition duration-300">
                                    <div class="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center mr-3">
                                        <i class="fas fa-headset text-blue-500"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-medium text-secondary">Contact Support</h4>
                                        <p class="text-sm text-gray-500">Need help with your shipment?</p>
                                    </div>
                                </a>

                                <a href="track-order" class="flex items-center p-3 bg-gray-50 hover:bg-gray-100 rounded-lg transition duration-300">
                                    <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center mr-3">
                                        <i class="fas fa-search text-green-500"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-medium text-secondary">Track Another Package</h4>
                                        <p class="text-sm text-gray-500">Enter a different tracking number</p>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- Shipment Tips -->
                    <div class="bg-white rounded-lg shadow-lg overflow-hidden">
                        <div class="p-4 bg-primary">
                            <h3 class="text-lg font-semibold text-white">Shipment Tips</h3>
                        </div>
                        <div class="p-4">
                            <ul class="space-y-4">
                                <li class="flex">
                                    <div class="flex-shrink-0 text-primary mr-3">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                    <p class="text-sm text-gray-600">Keep your tracking number handy for quick status checks.</p>
                                </li>
                                <li class="flex">
                                    <div class="flex-shrink-0 text-primary mr-3">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                    <p class="text-sm text-gray-600">Ensure someone is available at the delivery address during the expected delivery date.</p>
                                </li>
                                <li class="flex">
                                    <div class="flex-shrink-0 text-primary mr-3">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                    <p class="text-sm text-gray-600">Contact our support if you notice any issues with your tracking information.</p>
                                </li>
                                <li class="flex">
                                    <div class="flex-shrink-0 text-primary mr-3">
                                        <i class="fas fa-check-circle"></i>
                                    </div>
                                    <p class="text-sm text-gray-600">Print your shipping invoice before delivery for faster package processing.</p>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="py-12 bg-secondary relative">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">Need More Shipping Services?</h2>
                <p class="text-white text-opacity-90 mt-2">We provide international freight & courier services worldwide!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="services" class="bg-white text-secondary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-boxes text-secondary mr-2"></i>
                    View Our Services
                </a>
                <a href="request-quote" class="bg-primary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-calculator text-white mr-2"></i>
                    Get a Quote
                </a>
            </div>
        </div>
    </div>

    <!-- Wave Pattern Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>

@push('scripts')
<script>
    // Fix Font Awesome icons visibility
    document.addEventListener('DOMContentLoaded', function() {
        // Ensure all Font Awesome icons are visible
        ensureIconsAreVisible();

        // Set up MutationObserver to monitor DOM changes by Alpine.js
        const observer = new MutationObserver(function(mutations) {
            ensureIconsAreVisible();
        });

        // Start observing the document with the configured parameters
        observer.observe(document.body, {
            childList: true,
            subtree: true,
            attributes: true,
            attributeFilter: ['style', 'class']
        });

        function ensureIconsAreVisible() {
            // Force display of all Font Awesome icons
            document.querySelectorAll('.fas, .fab, .far, .fa, .fa-icon').forEach(function(icon) {
                icon.style.display = 'inline-block';
                icon.style.visibility = 'visible';
                icon.style.opacity = '1';

                // Fix for icons in specific backgrounds
                const parent = icon.closest('.bg-primary, .bg-primary-light, [class*="bg-primary"]');
                if (parent) {
                    icon.style.color = '#ffffff';
                }
            });
        }

        // Additional fix: periodically check if icons are visible
        setInterval(ensureIconsAreVisible, 1000);
    });
</script>
@endpush

@endsection
