@php
    if ($settings->redirect_url != null or !empty($settings->redirect_url)) {
        header("Location: $settings->redirect_url", true, 301);
        exit();
    }
@endphp
@extends('layouts.base')

@section('title', 'Our Services')

@section('styles')
@parent
<!-- Font Awesome Icons -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" integrity="sha512-iecdLmaskl7CVkqkXNQ/ZH/XLlvWZOJyj7Yy7tcenmpD1ypASozpmT/E0iPtmFIB46ZmdtAc9eNBvH0H/ZpiBw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<style>
    /* Force Font Awesome icons to always display */
    .fas, .fab, .far, .fa, .fa-icon, .service-icon {
        display: inline-block !important;
        visibility: visible !important;
        opacity: 1 !important;
    }

    /* Fix for Alpine.js hiding elements */
    [x-cloak] {
        display: block !important;
    }
</style>
@endsection

@inject('content', 'App\Http\Controllers\FrontController')
@section('content')

<!-- Page Header -->
<section class="relative bg-secondary py-16">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-secondary bg-opacity-90"></div>
        <div class="absolute w-96 h-96 -top-20 -left-20 bg-white opacity-5 rounded-full"></div>
        <div class="absolute w-96 h-96 bottom-0 right-0 bg-primary opacity-5 rounded-full"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="flex flex-col items-center">
            <h1 class="text-3xl md:text-4xl font-bold text-white mb-4">Our Services</h1>
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 text-sm text-white">
                    <li>
                        <a href="/" class="hover:text-primary transition-all">Home</a>
                    </li>
                    <li class="flex items-center">
                        <i class="fas fa-chevron-right w-4 h-4 mx-1 text-white"></i>
                        <span class="text-primary">Our Services</span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<!-- Main Services Content -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="flex flex-col lg:flex-row gap-8">
            <!-- Main Content -->
            <div class="w-full lg:w-2/3">
                <!-- Section Title -->
                <div class="flex items-center mb-6">
                    <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">01</div>
                    <h2 class="text-3xl font-bold text-secondary">Trade Services</h2>
                </div>

                <!-- Introduction -->
                <p class="text-lg font-medium text-gray-700 mb-6">What makes our service stand out from the crowd, however, is our ability to provide in-depth, expert knowledge of individual geographic trades and markets.</p>

                <p class="text-gray-600 mb-6">Regardless of your ocean freight needs, {{$settings->site_name}} can provide customized, high-quality Logistical Solutions for all import shipping tasks. Whether it be large or small, valuable or not, or come with a high degree of complexity, our worldwide network of experienced offices and agents can make even the most complex transportation scenario simple and trouble-free.</p>

                <p class="text-gray-600 mb-4">We are licensed as a Non-Vessel Operating Common Carrier or NVOCC. As such we can offer a comprehensive range of services including:</p>

                <!-- Services List -->
                <div class="bg-gray-50 rounded-lg p-6 mb-8">
                    <ul class="space-y-3">
                        <li class="flex items-start">
                            <i class="fas fa-check-circle text-white mt-1 mr-3 service-icon"></i>
                            <span class="text-gray-700">Customized freight solutions at competitive pricing</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check-circle text-white mt-1 mr-3 service-icon"></i>
                            <span class="text-gray-700">Timely alerts and notices with track-and-trace monitoring</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check-circle text-white mt-1 mr-3 service-icon"></i>
                            <span class="text-gray-700">ISF filing and full customs clearance</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check-circle text-white mt-1 mr-3 service-icon"></i>
                            <span class="text-gray-700">Local trucking and door-to-door delivery</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check-circle text-white mt-1 mr-3 service-icon"></i>
                            <span class="text-gray-700">Storage and warehouse options</span>
                        </li>
                        <li class="flex items-start">
                            <i class="fas fa-check-circle text-white mt-1 mr-3 service-icon"></i>
                            <span class="text-gray-700">Complete purchase order management</span>
                        </li>
                    </ul>
                </div>

                <!-- Featured Image -->
                <div class="mb-8 rounded-lg overflow-hidden shadow-md">
                    <img src="temp/custom/images/news-image4.jpg" alt="Logistics Services" class="w-full h-auto">
                </div>

                <p class="text-gray-600 mb-6">If you would like to contact us and discuss the import and cargo services we can offer, please feel free to write, call or email us with any questions or concerns you may have.</p>

                <p class="text-gray-600 mb-8">Supply chain sustainability is a trending topic nowadays because of people's growing awareness of environmental concerns. We strive to implement eco-friendly practices throughout our logistics network to reduce our carbon footprint.</p>

                <!-- Other Services Section -->
                <div class="mt-12">
                    <div class="flex items-center mb-8">
                        <div class="bg-primary text-white rounded-full w-8 h-8 flex items-center justify-center font-bold mr-3">02</div>
                        <h2 class="text-3xl font-bold text-secondary">Our Core Services</h2>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                        <!-- Service 1 -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300 border border-gray-100">
                            <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                                <i class="fas fa-plane w-8 h-8 text-white service-icon"></i>
                            </div>
                            <h3 class="text-lg font-bold text-secondary mb-2">AIR SHIPPING</h3>
                            <p class="text-gray-600">We offer premium air freight services with fast delivery times for urgent shipments, complete with real-time tracking and specialized handling.</p>
                            <a href="#air-shipping" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                                Learn More
                                <i class="fas fa-chevron-right w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1 service-icon"></i>
                            </a>
                        </div>

                        <!-- Service 2 -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300 border border-gray-100">
                            <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                                <i class="fas fa-truck w-8 h-8 text-white service-icon"></i>
                            </div>
                            <h3 class="text-lg font-bold text-secondary mb-2">GROUND LOGISTIC</h3>
                            <p class="text-gray-600">Our ground transportation network covers extensive areas with reliable, cost-effective delivery options for all types of cargo, from small packages to full truckloads.</p>
                            <a href="#ground-logistics" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                                Learn More
                                <i class="fas fa-chevron-right w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1 service-icon"></i>
                            </a>
                        </div>

                        <!-- Service 3 -->
                        <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all duration-300 border border-gray-100">
                            <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                                <i class="fas fa-ship w-8 h-8 text-white service-icon"></i>
                            </div>
                            <h3 class="text-lg font-bold text-secondary mb-2">SEA TRANSPORTATION</h3>
                            <p class="text-gray-600">Our sea freight services offer economical solutions for larger shipments, with container and bulk cargo options to destinations worldwide.</p>
                            <a href="#sea-transportation" class="mt-4 text-primary hover:text-secondary flex items-center text-sm font-medium">
                                Learn More
                                <i class="fas fa-chevron-right w-4 h-4 ml-1 transition-transform duration-300 group-hover:translate-x-1 service-icon"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Service Details Accordion -->
                <div class="mt-12" x-data="{ activeTab: 'none' }" x-cloak>
                    <h3 class="text-2xl font-bold text-secondary mb-6">Service Details</h3>

                    <!-- Accordion Item 1 -->
                    <div id="air-shipping" class="mb-4">
                        <button
                            @click="activeTab = (activeTab === 'air') ? 'none' : 'air'"
                            class="flex justify-between items-center w-full bg-gray-50 hover:bg-gray-100 p-4 rounded-lg focus:outline-none transition-all"
                            :class="{'bg-gray-100': activeTab === 'air'}"
                        >
                            <span class="font-medium text-left text-secondary flex items-center">
                                <i class="fas fa-plane mr-3 text-white service-icon"></i>
                                Air Shipping Services
                            </span>
                            <i class="fas fa-chevron-down transform transition-transform service-icon" :class="{'rotate-180': activeTab === 'air'}"></i>
                        </button>
                        <div
                            x-show="activeTab === 'air'"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="p-6 border border-t-0 border-gray-200 rounded-b-lg bg-white"
                        >
                            <p class="text-gray-600 mb-4">Our air freight services provide expedited shipping solutions for time-sensitive cargo. We partner with major airlines to ensure your shipments reach their destination quickly and securely.</p>
                            <ul class="list-disc pl-5 text-gray-600 space-y-2">
                                <li>Express air freight for urgent deliveries</li>
                                <li>Temperature-controlled shipping for sensitive items</li>
                                <li>Door-to-door service with customs clearance</li>
                                <li>Real-time tracking and notifications</li>
                                <li>Competitive rates with major airlines</li>
                            </ul>
                        </div>
                    </div>

                    <!-- Accordion Item 2 -->
                    <div id="ground-logistics" class="mb-4">
                        <button
                            @click="activeTab = (activeTab === 'ground') ? 'none' : 'ground'"
                            class="flex justify-between items-center w-full bg-gray-50 hover:bg-gray-100 p-4 rounded-lg focus:outline-none transition-all"
                            :class="{'bg-gray-100': activeTab === 'ground'}"
                        >
                            <span class="font-medium text-left text-secondary flex items-center">
                                <i class="fas fa-truck mr-3 text-white service-icon"></i>
                                Ground Logistics
                            </span>
                            <i class="fas fa-chevron-down transform transition-transform service-icon" :class="{'rotate-180': activeTab === 'ground'}"></i>
                        </button>
                        <div
                            x-show="activeTab === 'ground'"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="p-6 border border-t-0 border-gray-200 rounded-b-lg bg-white"
                        >
                            <p class="text-gray-600 mb-4">Our comprehensive ground logistics services cover all aspects of land transportation, from local delivery to long-haul trucking across regions.</p>
                            <ul class="list-disc pl-5 text-gray-600 space-y-2">
                                <li>Full truckload (FTL) and less-than-truckload (LTL) options</li>
                                <li>Expedited ground shipping for time-sensitive deliveries</li>
                                <li>Specialized equipment for oversized or heavy cargo</li>
                                <li>Last-mile delivery services</li>
                                <li>Intermodal transportation solutions</li>
                            </ul>
                        </div>
                    </div>

                    <!-- Accordion Item 3 -->
                    <div id="sea-transportation" class="mb-4">
                        <button
                            @click="activeTab = (activeTab === 'sea') ? 'none' : 'sea'"
                            class="flex justify-between items-center w-full bg-gray-50 hover:bg-gray-100 p-4 rounded-lg focus:outline-none transition-all"
                            :class="{'bg-gray-100': activeTab === 'sea'}"
                        >
                            <span class="font-medium text-left text-secondary flex items-center">
                                <i class="fas fa-ship mr-3 text-white service-icon"></i>
                                Sea Transportation
                            </span>
                            <i class="fas fa-chevron-down transform transition-transform service-icon" :class="{'rotate-180': activeTab === 'sea'}"></i>
                        </button>
                        <div
                            x-show="activeTab === 'sea'"
                            x-transition:enter="transition ease-out duration-200"
                            x-transition:enter-start="opacity-0 transform -translate-y-2"
                            x-transition:enter-end="opacity-100 transform translate-y-0"
                            class="p-6 border border-t-0 border-gray-200 rounded-b-lg bg-white"
                        >
                            <p class="text-gray-600 mb-4">Our ocean freight services provide cost-effective solutions for shipping large volumes of goods internationally. We offer both FCL (Full Container Load) and LCL (Less than Container Load) services.</p>
                            <ul class="list-disc pl-5 text-gray-600 space-y-2">
                                <li>FCL and LCL shipping options</li>
                                <li>Refrigerated container services for perishable goods</li>
                                <li>Break bulk and project cargo handling</li>
                                <li>Port-to-port or door-to-door service</li>
                                <li>Customs brokerage and documentation assistance</li>
                                <li>Cargo insurance options</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="w-full lg:w-1/3">
                <div class="sticky top-24">
                    <!-- Services Menu -->
                    <div class="bg-white rounded-lg shadow-md overflow-hidden mb-8">
                        <div class="bg-secondary p-4">
                            <h3 class="text-white font-bold">Our Services</h3>
                        </div>
                        <ul class="divide-y divide-gray-200">
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-secondary font-medium border-l-4 border-primary">
                                    <div class="flex items-center">
                                        <i class="fas fa-globe-americas mr-3 text-white service-icon"></i>
                                        Trade Services
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-gray-600 hover:text-secondary">
                                    <div class="flex items-center">
                                        <i class="fas fa-box mr-3 text-gray-400 service-icon"></i>
                                        Dry Cargo
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-gray-600 hover:text-secondary">
                                    <div class="flex items-center">
                                        <i class="fas fa-temperature-low mr-3 text-gray-400 service-icon"></i>
                                        Reefer Cargo
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-gray-600 hover:text-secondary">
                                    <div class="flex items-center">
                                        <i class="fas fa-truck-loading mr-3 text-gray-400 service-icon"></i>
                                        Oversized & Breakbulk Cargo
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-gray-600 hover:text-secondary">
                                    <div class="flex items-center">
                                        <i class="fas fa-exchange-alt mr-3 text-gray-400 service-icon"></i>
                                        Intermodal
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-gray-600 hover:text-secondary">
                                    <div class="flex items-center">
                                        <i class="fas fa-warehouse mr-3 text-gray-400 service-icon"></i>
                                        Warehousing & Storage
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-gray-600 hover:text-secondary">
                                    <div class="flex items-center">
                                        <i class="fas fa-handshake mr-3 text-gray-400 service-icon"></i>
                                        Cross Trading
                                    </div>
                                </a>
                            </li>
                            <li>
                                <a href="services" class="block p-4 hover:bg-gray-50 transition-all text-gray-600 hover:text-secondary">
                                    <div class="flex items-center">
                                        <i class="fas fa-trailer mr-3 text-gray-400 service-icon"></i>
                                        Cargo Trailers
                                    </div>
                                </a>
                            </li>
                        </ul>
                    </div>

                    <!-- Banner -->
                    <div class="bg-white rounded-lg shadow-md overflow-hidden mb-8">
                        <img src="temp/custom/images/side-image.jpg" alt="Banner" class="w-full h-auto">
                    </div>

                    <!-- Download Brochure -->
                    <div class="bg-primary rounded-lg shadow-md p-6 text-white">
                        <div class="flex items-center mb-4">
                            <i class="fas fa-file-pdf text-white text-3xl mr-4 service-icon"></i>
                            <div>
                                <h3 class="font-bold text-xl">Company Brochure</h3>
                                <p class="text-white text-opacity-80 text-sm">Download our complete services catalog</p>
                            </div>
                        </div>
                        <a href="#" class="block bg-white text-primary hover:bg-gray-100 py-3 px-4 rounded text-center font-medium transition-all duration-300">
                            <i class="fas fa-download mr-2 service-icon"></i>
                            DOWNLOAD PDF
                        </a>
                    </div>

                    <!-- Need Help Box -->
                    <div class="bg-secondary rounded-lg shadow-md p-6 text-white mt-8">
                        <h3 class="font-bold text-xl mb-4">Need Help?</h3>
                        <ul class="space-y-3">
                            <li class="flex items-start">
                                <i class="fas fa-phone-alt mt-1 mr-3 service-icon"></i>
                                <div>
                                    <p class="text-sm text-white text-opacity-80">Call us at</p>
                                    <p class="font-medium">{{ $settings->whatsapp }}</p>
                                </div>
                            </li>
                            <li class="flex items-start">
                                <i class="fas fa-envelope mt-1 mr-3 service-icon"></i>
                                <div>
                                    <p class="text-sm text-white text-opacity-80">Email us at</p>
                                    <p class="font-medium">{{ $settings->contact_email }}</p>
                                </div>
                            </li>
                        </ul>
                        <a href="contact" class="block bg-white text-secondary hover:bg-gray-100 py-2 px-4 rounded text-center font-medium mt-4 transition-all duration-300">
                            <i class="fas fa-paper-plane mr-2 service-icon"></i>
                            Contact Us
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Service Stats Section -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold text-secondary mb-2">Why Choose Our Services</h2>
            <p class="text-gray-600 max-w-2xl mx-auto">We deliver exceptional logistics solutions with precision, reliability, and customer-focused service that sets us apart from the competition.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <!-- Stat 1 -->
            <div class="bg-white rounded-lg shadow-md p-6 text-center" x-data="{ countUp: 0 }" x-init="() => { setTimeout(() => { for(let i=0; i<=98; i++) { setTimeout(() => { countUp = i; }, i*20); } }, 500) }" x-cloak>
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                    <i class="fas fa-globe w-8 h-8 text-white service-icon"></i>
                </div>
                <div class="text-4xl font-bold text-secondary mb-2">
                    <span x-text="countUp">0</span>+
                </div>
                <p class="text-gray-600">Countries Covered</p>
            </div>

            <!-- Stat 2 -->
            <div class="bg-white rounded-lg shadow-md p-6 text-center" x-data="{ countUp: 0 }" x-init="() => { setTimeout(() => { for(let i=0; i<=250; i+=5) { setTimeout(() => { countUp = i; }, i*8); } }, 500) }" x-cloak>
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                    <i class="fas fa-users w-8 h-8 text-white service-icon"></i>
                </div>
                <div class="text-4xl font-bold text-secondary mb-2">
                    <span x-text="countUp">0</span>K+
                </div>
                <p class="text-gray-600">Satisfied Clients</p>
            </div>

            <!-- Stat 3 -->
            <div class="bg-white rounded-lg shadow-md p-6 text-center" x-data="{ countUp: 0 }" x-init="() => { setTimeout(() => { for(let i=0; i<=15; i++) { setTimeout(() => { countUp = i; }, i*50); } }, 500) }" x-cloak>
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                    <i class="fas fa-building w-8 h-8 text-white service-icon"></i>
                </div>
                <div class="text-4xl font-bold text-secondary mb-2">
                    <span x-text="countUp">0</span>+
                </div>
                <p class="text-gray-600">Years of Experience</p>
            </div>

            <!-- Stat 4 -->
            <div class="bg-white rounded-lg shadow-md p-6 text-center" x-data="{ countUp: 0 }" x-init="() => { setTimeout(() => { for(let i=0; i<=500; i+=10) { setTimeout(() => { countUp = i; }, i*4); } }, 500) }" x-cloak>
                <div class="bg-primary bg-opacity-10 rounded-full p-4 inline-flex mb-4">
                    <i class="fas fa-shipping-fast w-8 h-8 text-white service-icon"></i>
                </div>
                <div class="text-4xl font-bold text-secondary mb-2">
                    <span x-text="countUp">0</span>K+
                </div>
                <p class="text-gray-600">Deliveries Completed</p>
            </div>
        </div>
    </div>
</section>

<!-- Call to Action Section -->
<section class="py-12 bg-secondary relative">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">Ready to Ship Your Package?</h2>
                <p class="text-white text-opacity-90 mt-2">Get in touch today for a free shipping quote!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="contact" class="bg-white text-secondary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-phone-alt mr-2 service-icon"></i>
                    Contact Us
                </a>
                <a href="request-quote" class="bg-primary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all duration-300 flex items-center">
                    <i class="fas fa-calculator mr-2 service-icon"></i>
                    Get a Quote
                </a>
            </div>
        </div>
    </div>

    <!-- Wave Pattern Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 48" class="text-white fill-current">
            <path d="M0,0L48,8C96,16,192,32,288,32C384,32,480,16,576,16C672,16,768,32,864,37.3C960,43,1056,37,1152,32C1248,27,1344,21,1392,18.7L1440,16L1440,48L1392,48C1344,48,1248,48,1152,48C1056,48,960,48,864,48C768,48,672,48,576,48C480,48,384,48,288,48C192,48,96,48,48,48L0,48Z"></path>
        </svg>
    </div>
</section>

@push('scripts')
<script>
    // Fix Alpine.js and Font Awesome compatibility issues
    document.addEventListener('DOMContentLoaded', function() {
        // Ensure all Font Awesome icons are visible
        ensureIconsAreVisible();

        // Set up MutationObserver to monitor DOM changes by Alpine.js
        const observer = new MutationObserver(function(mutations) {
            ensureIconsAreVisible();
        });

        // Start observing the document with the configured parameters
        observer.observe(document.body, {
            childList: true,
            subtree: true,
            attributes: true,
            attributeFilter: ['style', 'class']
        });

        function ensureIconsAreVisible() {
            // Force display of all Font Awesome icons
            document.querySelectorAll('.fas, .fab, .far, .fa, .fa-icon, .service-icon').forEach(function(icon) {
                icon.style.display = 'inline-block';
                icon.style.visibility = 'visible';
                icon.style.opacity = '1';
            });
        }

        // Additional fix: periodically check if icons are visible
        setInterval(ensureIconsAreVisible, 1000);
    });
</script>
@endpush
@endsection
