@extends('layouts.base')

@section('title', $settings->site_title)

@section('styles')
@parent
<style>
    /* Hide Alpine.js elements before initialization */
    [x-cloak] {
        display: none !important;
    }

    /* Animation for spinning loader */
    .animate-spin {
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        from { transform: rotate(0deg); }
        to { transform: rotate(360deg); }
    }
</style>
@endsection


@inject('content', 'App\Http\Controllers\FrontController')
@section('content')

<div x-data="{ quickTrackModal: false }">
    <!-- Quick Track Modal - Simple Design -->
    <div x-show="quickTrackModal"
         x-transition:enter="transition ease-out duration-300"
         x-transition:enter-start="opacity-0"
         x-transition:enter-end="opacity-100"
         x-transition:leave="transition ease-in duration-200"
         x-transition:leave-start="opacity-100"
         x-transition:leave-end="opacity-0"
         class="fixed inset-0 z-50 flex items-center justify-center p-4"
         style="background: rgba(0, 0, 0, 0.6);"
         x-cloak>

        <div x-show="quickTrackModal"
             x-transition:enter="transition ease-out duration-300 delay-100"
             x-transition:enter-start="opacity-0 transform scale-95"
             x-transition:enter-end="opacity-100 transform scale-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100 transform scale-100"
             x-transition:leave-end="opacity-0 transform scale-95"
             @click.away="quickTrackModal = false"
             class="relative bg-white rounded-lg shadow-2xl max-w-md w-full mx-4 overflow-hidden"
             x-cloak>

            <!-- Close button -->
            <button @click="quickTrackModal = false"
                    class="absolute top-3 right-3 z-10 w-8 h-8 flex items-center justify-center rounded-full bg-gray-100 hover:bg-gray-200 text-gray-600 hover:text-gray-800 transition-all duration-200">
                <i class="fas fa-times text-sm"></i>
            </button>

            <!-- Modal Content -->
            <div class="p-8 text-center">
                <!-- Icon -->
                <div class="w-16 h-16 mx-auto mb-4 bg-primary bg-opacity-10 rounded-full flex items-center justify-center">
                    <i class="fas fa-search text-2xl text-white"></i>
                </div>

                <!-- Title -->
                <h2 class="text-xl font-bold text-secondary mb-2">Track Your Shipment</h2>

                <!-- Description -->
                <p class="text-gray-600 mb-6 text-sm">Enter your tracking number to get real-time updates on your shipment.</p>

                <!-- Form -->
                <form method="POST" action="{{ route('trackingresult') }}"
                      x-data="{ isSubmitting: false }"
                      x-cloak
                      @submit="isSubmitting = true">
                    @csrf

                    <!-- Input field -->
                    <div class="mb-4">
                        <input type="text"
                               name="trackingnumber"
                               placeholder="Enter tracking number"
                               class="w-full px-4 py-3 text-gray-700 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary focus:border-primary"
                               required
                               autocomplete="off">
                    </div>

                    <!-- Track button -->
                    <button type="submit"
                            :disabled="isSubmitting"
                            :class="{ 'opacity-75 cursor-not-allowed': isSubmitting }"
                            class="w-full bg-primary hover:bg-secondary text-white font-semibold py-3 px-6 rounded-md transition-all duration-200">
                        <span x-show="!isSubmitting">Track Now</span>
                        <span x-show="isSubmitting" class="flex items-center justify-center">
                            <i class="fas fa-spinner fa-spin mr-2"></i>
                            Tracking...
                        </span>
                    </button>
                </form>
            </div>
        </div>
    </div>

<!-- Hero Section with Tracking Form -->
<section class="relative bg-hero-gradient py-16 md:py-28">
    <div class="absolute inset-0 overflow-hidden">
        <div class="absolute inset-0 bg-gradient-to-r from-secondary to-accent-color opacity-90"></div>
    </div>

    <div class="container mx-auto px-4 relative z-10">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 items-center">
            <!-- Hero Content -->
            <div class="text-white">
                <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold leading-tight mb-4">
                    Fast & Reliable <span class="text-primary">Logistics</span> Solutions
                </h1>
                <p class="text-lg opacity-90 mb-8 max-w-lg">
                    We provide efficient shipping and tracking services worldwide. Your packages are always in safe hands with our professional team.
                </p>
                <div class="flex flex-wrap gap-4">
                    <a href="services" class="bg-primary hover:bg-primary-dark text-white py-3 px-6 rounded-md font-medium transition-all flex items-center">
                        <i data-lucide="package" class="w-5 h-5 mr-2"></i>
                        Our Services
                    </a>
                    <a href="request-quote" class="bg-white text-secondary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all flex items-center">
                        <i data-lucide="clipboard-list" class="w-5 h-5 mr-2"></i>
                        Get a Quote
                    </a>
                </div>
            </div>

            <!-- Tracking Form Card -->
            <div class="bg-white rounded-lg shadow-xl p-6 md:p-8">
                <div class="mb-6 text-center">
                    <h2 class="text-2xl font-bold text-secondary mb-2">Track Your Package</h2>
                    <p class="text-gray-600">Enter your tracking number to get real-time updates</p>
                </div>

                @if (Session::has('error'))
                <div class="bg-red-100 border-l-4 border-red-500 text-red-700 p-4 mb-4" role="alert">
                    <p class="font-medium">Error! You have entered an incorrect Tracking Number.</p>
                </div>
                @endif

                <form method="POST" action="{{ route('trackingresult') }}" class="space-y-4">
                    @csrf
                    <div class="relative">
                        <i data-lucide="search" class="absolute top-3.5 left-4 h-5 w-5 text-gray-400"></i>
                        <input
                            type="text"
                            name="trackingnumber"
                            placeholder="Enter your tracking number"
                            class="w-full py-3 pl-12 pr-4 text-gray-700 bg-white border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                            required
                        >
                    </div>

                    <button type="submit" class="w-full bg-primary hover:bg-primary-dark text-white font-medium py-3 px-4 rounded-md transition-all flex items-center justify-center">
                        <i data-lucide="truck" class="w-5 h-5 mr-2"></i>
                        TRACK ORDER
                    </button>
                </form>
            </div>
        </div>
    </div>

    <!-- Wave Bottom -->
    <div class="absolute bottom-0 left-0 right-0">
        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1440 120">
            <path fill="#ffffff" fill-opacity="1" d="M0,64L80,80C160,96,320,128,480,122.7C640,117,800,75,960,64C1120,53,1280,75,1360,85.3L1440,96L1440,120L1360,120C1280,120,1120,120,960,120C800,120,640,120,480,120C320,120,160,120,80,120L0,120Z"></path>
        </svg>
    </div>
</section>

<!-- Services Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <span class="bg-primary text-white text-sm font-bold py-1 px-3 rounded-full">OUR SERVICES</span>
            <h2 class="text-3xl font-bold mt-4 mb-2 text-secondary">Shipping Services We Offer</h2>
            <p class="text-gray-600 max-w-xl mx-auto">Bringing you industry-specific expertise; whatever you're shipping, wherever you're shipping it.</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Service 1 -->
            <div class="bg-white border border-gray-200 rounded-lg shadow-md transition-transform hover:transform hover:scale-105 overflow-hidden group">
                <div class="bg-secondary h-1 w-full group-hover:bg-primary transition-colors"></div>
                <div class="p-6">
                    <div class="mb-4 bg-gray-100 p-3 inline-block rounded-full">
                        <i data-lucide="ship" class="w-8 h-8 text-primary"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Sea Shipping</h3>
                    <p class="text-gray-600 mb-4">We ensure it's as easy as possible to use our services to get your shipments moving across oceans worldwide.</p>
                    <a href="services" class="text-primary hover:text-secondary flex items-center font-medium">
                        Learn More
                        <i data-lucide="chevron-right" class="w-4 h-4 ml-1"></i>
                    </a>
                </div>
            </div>

            <!-- Service 2 -->
            <div class="bg-white border border-gray-200 rounded-lg shadow-md transition-transform hover:transform hover:scale-105 overflow-hidden group">
                <div class="bg-secondary h-1 w-full group-hover:bg-primary transition-colors"></div>
                <div class="p-6">
                    <div class="mb-4 bg-gray-100 p-3 inline-block rounded-full">
                        <i data-lucide="plane" class="w-8 h-8 text-primary"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Air Shipping</h3>
                    <p class="text-gray-600 mb-4">Fast and reliable air freight solutions for time-sensitive shipments, whether you've worked with us for years or are completely new.</p>
                    <a href="services" class="text-primary hover:text-secondary flex items-center font-medium">
                        Learn More
                        <i data-lucide="chevron-right" class="w-4 h-4 ml-1"></i>
                    </a>
                </div>
            </div>

            <!-- Service 3 -->
            <div class="bg-white border border-gray-200 rounded-lg shadow-md transition-transform hover:transform hover:scale-105 overflow-hidden group">
                <div class="bg-secondary h-1 w-full group-hover:bg-primary transition-colors"></div>
                <div class="p-6">
                    <div class="mb-4 bg-gray-100 p-3 inline-block rounded-full">
                        <i data-lucide="truck" class="w-8 h-8 text-primary"></i>
                    </div>
                    <h3 class="text-xl font-bold mb-2">Land Shipping</h3>
                    <p class="text-gray-600 mb-4">Domestic and international land transport with comprehensive tracking for all your ground shipping needs.</p>
                    <a href="services" class="text-primary hover:text-secondary flex items-center font-medium">
                        Learn More
                        <i data-lucide="chevron-right" class="w-4 h-4 ml-1"></i>
                    </a>
                </div>
            </div>
        </div>

        <div class="mt-12 text-center">
            <a href="services" class="inline-flex items-center bg-secondary hover:bg-primary text-white py-3 px-6 rounded-md font-medium transition-all">
                View All Services
                <i data-lucide="arrow-right" class="w-4 h-4 ml-2"></i>
            </a>
        </div>
    </div>
</section>

<!-- Quote Request Section -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="bg-white shadow-2xl rounded-2xl overflow-hidden">
            <div class="grid grid-cols-1 lg:grid-cols-2">
                <!-- Left Image -->
                <div class="relative bg-cover bg-center min-h-[400px]" style="background-image: url('temp/custom/images/banner2.jpg');">
                    <div class="absolute inset-0 bg-gradient-to-r from-secondary/80 to-primary/60"></div>
                    <div class="relative z-10 h-full p-12 flex flex-col justify-center">
                        <div class="bg-white/95 backdrop-blur-sm p-8 rounded-2xl max-w-md">
                            <h3 class="text-2xl font-bold text-secondary mb-4">Why Choose Us?</h3>
                            <ul class="space-y-3">
                                <li class="flex items-center">
                                    <div class="w-6 h-6 bg-primary rounded-full flex items-center justify-center mr-3">
                                        <i data-lucide="check" class="w-4 h-4 text-white"></i>
                                    </div>
                                    <span class="font-medium">Professional, efficient service</span>
                                </li>
                                <li class="flex items-center">
                                    <div class="w-6 h-6 bg-primary rounded-full flex items-center justify-center mr-3">
                                        <i data-lucide="check" class="w-4 h-4 text-white"></i>
                                    </div>
                                    <span class="font-medium">Tailored to your business needs</span>
                                </li>
                                <li class="flex items-center">
                                    <div class="w-6 h-6 bg-primary rounded-full flex items-center justify-center mr-3">
                                        <i data-lucide="check" class="w-4 h-4 text-white"></i>
                                    </div>
                                    <span class="font-medium">Worldwide shipping network</span>
                                </li>
                                <li class="flex items-center">
                                    <div class="w-6 h-6 bg-primary rounded-full flex items-center justify-center mr-3">
                                        <i data-lucide="check" class="w-4 h-4 text-white"></i>
                                    </div>
                                    <span class="font-medium">Real-time tracking and updates</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>

                <!-- Request Form -->
                <div class="p-6 md:p-10 bg-secondary">
                    <h2 class="text-2xl font-bold text-white mb-6">REQUEST A FREE QUOTE</h2>

                    <div x-data="{
                        isSubmitting: false,
                        submitError: '',
                        submitSuccess: false,
                        referenceNumber: '',
                        formData: {
                            freightType: '',
                            email: '',
                            departureCountry: '',
                            weight: '',
                            recipientCountry: '',
                            expectedDeliveryDate: '',
                            fullName: '',
                            phone: ''
                        },
                        async submitForm() {
                            this.isSubmitting = true;
                            this.submitError = '';

                            try {
                                const formData = new FormData();
                                formData.append('freight_type', this.formData.freightType);
                                formData.append('email', this.formData.email);
                                formData.append('departure_country', this.formData.departureCountry);
                                formData.append('weight', this.formData.weight);
                                formData.append('recipient_country', this.formData.recipientCountry);
                                formData.append('expected_delivery_date', this.formData.expectedDeliveryDate);
                                formData.append('full_name', this.formData.fullName);
                                formData.append('phone', this.formData.phone);
                                formData.append('priority', 'standard');
                                formData.append('insurance', '0');
                                formData.append('_token', '{{ csrf_token() }}');

                                const response = await fetch('{{ route('submit-quote') }}', {
                                    method: 'POST',
                                    body: formData,
                                    headers: {
                                        'X-Requested-With': 'XMLHttpRequest'
                                    }
                                });

                                const result = await response.json();

                                if (result.success) {
                                    this.referenceNumber = result.reference_number;
                                    this.submitSuccess = true;
                                    // Reset form
                                    this.formData = {
                                        freightType: '',
                                        email: '',
                                        departureCountry: '',
                                        weight: '',
                                        recipientCountry: '',
                                        expectedDeliveryDate: '',
                                        fullName: '',
                                        phone: ''
                                    };
                                } else {
                                    this.submitError = result.message || 'Please check your form and try again.';
                                    if (result.errors) {
                                        const firstError = Object.values(result.errors)[0];
                                        this.submitError = Array.isArray(firstError) ? firstError[0] : firstError;
                                    }
                                }
                            } catch (error) {
                                console.error('Form submission error:', error);
                                this.submitError = 'Network error. Please check your connection and try again.';
                            } finally {
                                this.isSubmitting = false;
                            }
                        },
                        validateForm() {
                            if (!this.formData.freightType || !this.formData.email ||
                                !this.formData.departureCountry || !this.formData.recipientCountry ||
                                !this.formData.fullName) {
                                this.submitError = 'Please fill out all required fields.';
                                return false;
                            }
                            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                            if (!emailRegex.test(this.formData.email)) {
                                this.submitError = 'Please enter a valid email address.';
                                return false;
                            }
                            return true;
                        }
                    }" x-cloak>

                        <!-- Success Message -->
                        <div x-show="submitSuccess" x-cloak class="bg-green-100 border border-green-200 rounded-lg p-4 mb-6">
                            <div class="flex items-center">
                                <i data-lucide="check-circle" class="w-5 h-5 text-green-600 mr-3"></i>
                                <div>
                                    <p class="text-green-800 font-medium">Quote request submitted successfully!</p>
                                    <p class="text-green-700 text-sm" x-show="referenceNumber">
                                        Reference: <span class="font-bold" x-text="referenceNumber"></span>
                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- Error Message -->
                        <div x-show="submitError" x-cloak class="bg-red-100 border border-red-200 rounded-lg p-4 mb-6">
                            <div class="flex items-center">
                                <i data-lucide="alert-circle" class="w-5 h-5 text-red-600 mr-3"></i>
                                <p class="text-red-800 text-sm" x-text="submitError"></p>
                            </div>
                        </div>

                        <form @submit.prevent="validateForm() && submitForm()" class="space-y-4">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <!-- Freight Type -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Freight Type <span class="text-red-300">*</span></label>
                                    <div class="relative">
                                        <select
                                            x-model="formData.freightType"
                                            class="appearance-none bg-white border border-gray-300 text-gray-700 py-3 px-4 pr-8 rounded leading-tight focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent w-full"
                                            required
                                        >
                                            <option value="">-- Select Type</option>
                                            <option value="Air Freight">Air Freight</option>
                                            <option value="Ocean Freight">Ocean Freight</option>
                                            <option value="Road Freight">Road Freight</option>
                                        </select>
                                        <div class="pointer-events-none absolute inset-y-0 right-0 flex items-center px-2 text-gray-700">
                                            <i data-lucide="chevron-down" class="w-4 h-4"></i>
                                        </div>
                                    </div>
                                </div>

                                <!-- Email Address -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Email Address <span class="text-red-300">*</span></label>
                                    <input
                                        x-model="formData.email"
                                        type="email"
                                        placeholder="Email"
                                        class="w-full py-3 px-4 text-gray-700 bg-white border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                        required
                                    >
                                </div>

                                <!-- Full Name -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Full Name <span class="text-red-300">*</span></label>
                                    <input
                                        x-model="formData.fullName"
                                        type="text"
                                        placeholder="Your Full Name"
                                        class="w-full py-3 px-4 text-gray-700 bg-white border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                        required
                                    >
                                </div>

                                <!-- Phone -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Phone Number</label>
                                    <input
                                        x-model="formData.phone"
                                        type="tel"
                                        placeholder="Your Phone Number"
                                        class="w-full py-3 px-4 text-gray-700 bg-white border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                    >
                                </div>

                                <!-- Departure Country -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Departure Country <span class="text-red-300">*</span></label>
                                    <input
                                        x-model="formData.departureCountry"
                                        type="text"
                                        placeholder="Country of Departure"
                                        class="w-full py-3 px-4 text-gray-700 bg-white border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                        required
                                    >
                                </div>

                                <!-- Weight -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Total Weight (KG)</label>
                                    <input
                                        x-model="formData.weight"
                                        type="text"
                                        placeholder="Total Weight"
                                        class="w-full py-3 px-4 text-gray-700 bg-white border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                    >
                                </div>

                                <!-- Recipient Country -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Recipient's Country <span class="text-red-300">*</span></label>
                                    <input
                                        x-model="formData.recipientCountry"
                                        type="text"
                                        placeholder="Recipient Country"
                                        class="w-full py-3 px-4 text-gray-700 bg-white border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                        required
                                    >
                                </div>

                                <!-- Expected Delivery Date -->
                                <div>
                                    <label class="block text-white text-sm font-medium mb-2">Expected Delivery Date</label>
                                    <input
                                        x-model="formData.expectedDeliveryDate"
                                        type="date"
                                        class="w-full py-3 px-4 text-gray-700 bg-white border border-gray-300 rounded focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                    >
                                </div>
                            </div>

                            <!-- Submit Button -->
                            <button
                                type="submit"
                                :disabled="isSubmitting"
                                :class="{ 'opacity-75 cursor-not-allowed': isSubmitting }"
                                class="w-full bg-primary hover:bg-primary-dark text-white font-medium py-3 px-4 rounded transition-all flex items-center justify-center"
                            >
                                <span x-show="!isSubmitting" class="flex items-center">
                                    <i data-lucide="send" class="w-4 h-4 mr-2"></i>
                                    Submit Request
                                </span>
                                <span x-show="isSubmitting" x-cloak class="flex items-center">
                                    <i data-lucide="loader" class="w-4 h-4 mr-2 animate-spin"></i>
                                    Submitting...
                                </span>
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- How It Works Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <span class="bg-primary text-white text-sm font-bold py-1 px-3 rounded-full">HOW IT WORKS</span>
            <h2 class="text-3xl font-bold mt-4 mb-2 text-secondary">Our Delivery Process</h2>
            <p class="text-gray-600 max-w-xl mx-auto">Follow these simple steps to get your package from pickup to delivery</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8 mt-8">
            <!-- Step 1 -->
            <div class="bg-gray-50 rounded-lg p-6 text-center relative hover:shadow-lg transition-all">
                <div class="absolute -top-5 left-1/2 transform -translate-x-1/2 bg-primary text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">
                    01
                </div>
                <div class="mt-6 mb-4">
                    <i data-lucide="package" class="w-12 h-12 mx-auto text-primary"></i>
                </div>
                <h3 class="text-xl font-bold mb-2 text-secondary">PACKING</h3>
                <p class="text-gray-600">We professionally pack your items for maximum safety during transit and storage</p>
                <a href="#" class="inline-block mt-4 text-primary hover:text-secondary flex items-center justify-center font-medium">
                    READ MORE
                    <i data-lucide="arrow-right" class="w-4 h-4 ml-1"></i>
                </a>
            </div>

            <!-- Step 2 -->
            <div class="bg-primary rounded-lg p-6 text-center relative shadow-lg transform md:-translate-y-4">
                <div class="absolute -top-5 left-1/2 transform -translate-x-1/2 bg-white text-primary w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">
                    02
                </div>
                <div class="mt-6 mb-4">
                    <i data-lucide="globe" class="w-12 h-12 mx-auto text-white"></i>
                </div>
                <h3 class="text-xl font-bold mb-2 text-white">LANDING</h3>
                <p class="text-gray-100">Our global network ensures smooth customs clearance and efficient handling</p>
                <a href="#" class="inline-block mt-4 text-white hover:text-gray-200 flex items-center justify-center font-medium">
                    READ MORE
                    <i data-lucide="arrow-right" class="w-4 h-4 ml-1"></i>
                </a>
            </div>

            <!-- Step 3 -->
            <div class="bg-gray-50 rounded-lg p-6 text-center relative hover:shadow-lg transition-all">
                <div class="absolute -top-5 left-1/2 transform -translate-x-1/2 bg-primary text-white w-10 h-10 rounded-full flex items-center justify-center font-bold text-lg">
                    03
                </div>
                <div class="mt-6 mb-4">
                    <i data-lucide="truck" class="w-12 h-12 mx-auto text-primary"></i>
                </div>
                <h3 class="text-xl font-bold mb-2 text-secondary">DELIVERY</h3>
                <p class="text-gray-600">Timely and secure delivery to the final destination with real-time tracking</p>
                <a href="#" class="inline-block mt-4 text-primary hover:text-secondary flex items-center justify-center font-medium">
                    READ MORE
                    <i data-lucide="arrow-right" class="w-4 h-4 ml-1"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="py-16 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <span class="bg-primary text-white text-sm font-bold py-1 px-3 rounded-full">TESTIMONIALS</span>
            <h2 class="text-3xl font-bold mt-4 mb-2 text-secondary">What Our Clients Say</h2>
            <p class="text-gray-600 max-w-xl mx-auto">Hear from our satisfied customers about their experience with our services</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Testimonial 1 -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all">
                <div class="flex items-center mb-4">
                    <div class="text-yellow-400 flex">
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                    </div>
                </div>
                <blockquote class="text-gray-600 italic mb-6">
                    {{$settings->site_name}} is a world leader in global container shipping and a company offering global service with local knowledge. They provide an integrated network of road, rail and sea transport resources which stretches across the globe.
                </blockquote>
                <div class="flex items-center">
                    <img src="temp/custom/images/testimonial-head1.png" alt="Steve Hardy" class="w-12 h-12 rounded-full mr-4">
                    <div>
                        <h4 class="font-bold text-secondary">Steve Hardy</h4>
                        <p class="text-sm text-gray-500">Jewelry Stores</p>
                    </div>
                </div>
            </div>

            <!-- Testimonial 2 -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all">
                <div class="flex items-center mb-4">
                    <div class="text-yellow-400 flex">
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                    </div>
                </div>
                <blockquote class="text-gray-600 italic mb-6">
                    {{$settings->site_name}} is privately owned global organisation operating a network of over 480 offices in 150 countries, employing a team of over 24,000 dedicated individuals. They have an established fleet of 480 container vessels.
                </blockquote>
                <div class="flex items-center">
                    <img src="temp/custom/images/testimonial-head2.png" alt="Jessica Carter" class="w-12 h-12 rounded-full mr-4">
                    <div>
                        <h4 class="font-bold text-secondary">Jessica Carter</h4>
                        <p class="text-sm text-gray-500">Apple Inc</p>
                    </div>
                </div>
            </div>

            <!-- Testimonial 3 -->
            <div class="bg-white rounded-lg shadow-md p-6 hover:shadow-lg transition-all">
                <div class="flex items-center mb-4">
                    <div class="text-yellow-400 flex">
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                        <i data-lucide="star" class="w-5 h-5 fill-current"></i>
                    </div>
                </div>
                <blockquote class="text-gray-600 italic mb-6">
                    Their sea freight offering is complemented by integrated warehousing and haulage services, enabling them to offer a true door-to-door service. As a company, they operate as independent national carriers, offering global service.
                </blockquote>
                <div class="flex items-center">
                    <img src="temp/custom/images/testimonial-head3.png" alt="Chris O'Conner" class="w-12 h-12 rounded-full mr-4">
                    <div>
                        <h4 class="font-bold text-secondary">Chris O'Conner</h4>
                        <p class="text-sm text-gray-500">Digital Power</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Latest News Section -->
<section class="py-16 bg-white">
    <div class="container mx-auto px-4">
        <div class="text-center mb-12">
            <span class="bg-primary text-white text-sm font-bold py-1 px-3 rounded-full">UPDATES</span>
            <h2 class="text-3xl font-bold mt-4 mb-2 text-secondary">Latest News</h2>
            <p class="text-gray-600 max-w-xl mx-auto">Stay updated with the latest happenings in our company and the logistics industry</p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- News 1 -->
            <div class="bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-lg transition-all">
                <img src="temp/custom/images/news1.jpg" alt="News" class="w-full h-48 object-cover">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-4">
                        <span class="text-sm text-gray-500">02/OCT</span>
                        <span class="bg-secondary text-white text-xs py-1 px-2 rounded">Company</span>
                    </div>
                    <h3 class="text-xl font-bold mb-2 text-secondary">Social and demographic information</h3>
                    <p class="text-gray-600 mb-4">There are no hidden costs associated with our transportation services. We provide transparent pricing for all our logistics solutions.</p>
                    <a href="#" class="text-primary hover:text-secondary flex items-center font-medium">
                        READ MORE
                        <i data-lucide="arrow-right" class="w-4 h-4 ml-1"></i>
                    </a>
                </div>
            </div>

            <!-- News 2 -->
            <div class="bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-lg transition-all">
                <img src="temp/custom/images/news2.jpg" alt="News" class="w-full h-48 object-cover">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-4">
                        <span class="text-sm text-gray-500">02/OCT</span>
                        <span class="bg-secondary text-white text-xs py-1 px-2 rounded">Service</span>
                    </div>
                    <h3 class="text-xl font-bold mb-2 text-secondary">Team member to discuss our meeting</h3>
                    <p class="text-gray-600 mb-4">Offers you peace-of-mind that we'll be on-hand to help whenever you need us. Our customer support team is available 24/7.</p>
                    <a href="#" class="text-primary hover:text-secondary flex items-center font-medium">
                        READ MORE
                        <i data-lucide="arrow-right" class="w-4 h-4 ml-1"></i>
                    </a>
                </div>
            </div>

            <!-- News 3 -->
            <div class="bg-white border border-gray-200 rounded-lg overflow-hidden shadow-sm hover:shadow-lg transition-all">
                <img src="temp/custom/images/news3.jpg" alt="News" class="w-full h-48 object-cover">
                <div class="p-6">
                    <div class="flex justify-between items-center mb-4">
                        <span class="text-sm text-gray-500">02/OCT</span>
                        <span class="bg-secondary text-white text-xs py-1 px-2 rounded">Industry</span>
                    </div>
                    <h3 class="text-xl font-bold mb-2 text-secondary">Financial Institutions changes control</h3>
                    <p class="text-gray-600 mb-4">As a company, we believe in operating as independent national carriers, which allows us to provide specialized local service globally.</p>
                    <a href="#" class="text-primary hover:text-secondary flex items-center font-medium">
                        READ MORE
                        <i data-lucide="arrow-right" class="w-4 h-4 ml-1"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Partners Section -->
<section class="py-12 bg-gray-50">
    <div class="container mx-auto px-4">
        <div class="text-center mb-8">
            <h2 class="text-2xl font-bold text-secondary">Our Trusted Partners</h2>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4 items-center">
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo1.jpg" alt="Partner" class="max-h-12">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo2.jpg" alt="Partner" class="max-h-12">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo3.jpg" alt="Partner" class="max-h-12">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo4.jpg" alt="Partner" class="max-h-12">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo5.jpg" alt="Partner" class="max-h-12">
            </div>
            <div class="bg-white p-4 rounded-lg flex items-center justify-center hover:shadow-md transition-all h-24">
                <img src="temp/custom/images/logo6.jpg" alt="Partner" class="max-h-12">
            </div>
        </div>
    </div>
</section>

<!-- About Section -->
<section class="py-16 bg-white relative">
    <div class="container mx-auto px-4">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Content Column -->
            <div class="pr-0 lg:pr-8">
                <span class="bg-primary text-white text-sm font-bold py-1 px-3 rounded-full">ABOUT US</span>
                <h2 class="text-3xl font-bold mt-4 mb-4 text-secondary">About {{$settings->site_name}}</h2>

                <p class="text-gray-600 mb-6">We have trained, experienced experts available for our full range of services including reefer, out-of-gauge, breakbulk and each of our trade services – each operating in tandem with your business. This gives us the ability to uphold the personal service we're globally recognized for.</p>

                <!-- Stats -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-6">
                    <div class="bg-gray-50 rounded-lg p-6">
                        <div class="flex items-center space-x-4">
                            <i data-lucide="award" class="w-12 h-12 text-primary"></i>
                            <div>
                                <h3 class="text-3xl font-bold text-secondary">1,246+</h3>
                                <p class="text-gray-600">Awards Received</p>
                            </div>
                        </div>
                    </div>
                    <div class="bg-gray-50 rounded-lg p-6">
                        <div class="flex items-center space-x-4">
                            <i data-lucide="package" class="w-12 h-12 text-primary"></i>
                            <div>
                                <h3 class="text-3xl font-bold text-secondary">2,638+</h3>
                                <p class="text-gray-600">Packages Delivered</p>
                            </div>
                        </div>
                    </div>
                </div>

                <a href="about" class="inline-flex items-center bg-secondary hover:bg-primary text-white py-3 px-6 rounded-md font-medium transition-all">
                    Learn More About Us
                    <i data-lucide="arrow-right" class="w-4 h-4 ml-2"></i>
                </a>
            </div>

            <!-- Image Column -->
            <div class="relative bg-cover bg-center rounded-2xl overflow-hidden min-h-[500px]" style="background-image: url('temp/custom/images/banner1.jpg');">
                <div class="absolute inset-0 bg-gradient-to-r from-secondary/80 to-primary/60"></div>
                <div class="relative z-10 h-full flex flex-col justify-center items-center p-8">
                    <div class="text-center mb-8">
                        <h2 class="text-4xl md:text-6xl font-bold text-white mb-4">LOGISTICS</h2>
                        <p class="text-white/90 text-lg max-w-md">Your trusted partner in global shipping and logistics solutions</p>
                    </div>
                    <a href="#" class="inline-flex items-center bg-primary hover:bg-white hover:text-primary text-white py-3 px-8 rounded-lg font-semibold transition-all shadow-lg">
                        <i data-lucide="play" class="w-5 h-5 mr-2"></i>
                        Watch Our Story
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="bg-primary py-12">
    <div class="container mx-auto px-4">
        <div class="flex flex-col md:flex-row items-center justify-between">
            <div class="mb-6 md:mb-0">
                <h2 class="text-2xl md:text-3xl font-bold text-white">Ready to Ship Your Package?</h2>
                <p class="text-white text-opacity-90 mt-2">Contact us today for a free shipping quote!</p>
            </div>
            <div class="flex flex-wrap gap-4">
                <a href="contact" class="bg-white text-primary hover:bg-gray-100 py-3 px-6 rounded-md font-medium transition-all flex items-center">
                    <i data-lucide="phone" class="w-5 h-5 mr-2"></i>
                    Contact Us
                </a>
                <a href="request-quote" class="bg-secondary text-white hover:bg-opacity-90 py-3 px-6 rounded-md font-medium transition-all flex items-center">
                    <i data-lucide="clipboard-check" class="w-5 h-5 mr-2"></i>
                    Get a Quote
                </a>
            </div>
        </div>
    </div>
</section>

</div> <!-- End of x-data div -->

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Show modal automatically after page loads
        setTimeout(function() {
            // Find the Alpine.js component and show modal
            const alpineComponent = document.querySelector('[x-data*="quickTrackModal"]');
            if (alpineComponent && alpineComponent._x_dataStack) {
                alpineComponent._x_dataStack[0].quickTrackModal = true;
            }
        }, 1500); // Show after 1.5 seconds
    });
</script>
@endpush

@endsection
