@component('mail::message')
# Shipment Status Update

@if($emailType === 'sender')
Dear **{{ $shipmentData['sname'] }}**,

We are writing to inform you about an important update regarding your shipment with **{{ $settings->site_name }}**. The status of your package has been updated in our system.
@else
Dear **{{ $shipmentData['name'] }}**,

We wanted to keep you informed about your incoming shipment. There has been an update to the status of your package being handled by **{{ $settings->site_name }}**.
@endif

## Updated Shipment Information

@component('mail::panel')
**Tracking Number:** {{ $shipmentData['trackingnumber'] }}
**Current Status:** {{ $shipmentData['status'] }}
**Current Location:** {{ $shipmentData['location'] }}
**Current Address:** {{ $shipmentData['addresslocation'] }}

---

**From:** {{ $shipmentData['take_off_point'] ?? $shipmentData['saddress'] }}
**To:** {{ $shipmentData['final_destination'] ?? $shipmentData['address'] }}
**Service Type:** {{ $shipmentData['freight_type'] }}
**Content Type:** {{ $shipmentData['shipment_type'] }}
**Weight:** {{ $shipmentData['weight'] }}
**Date Shipped:** {{ \Carbon\Carbon::parse($shipmentData['date_shipped'])->format('M d, Y \a\t h:i A') }}
**Expected Delivery:** {{ \Carbon\Carbon::parse($shipmentData['expected_delivery'])->format('M d, Y \a\t h:i A') }}

@if($shipmentData['percentage_complete'])
**Delivery Progress:** {{ $shipmentData['percentage_complete'] }}% Complete
@endif
@endcomponent

@if($shipmentData['description'])
**Shipment Description:** {{ $shipmentData['description'] }}
@endif

## What This Update Means

@if($shipmentData['status'] === 'In Transit')
✅ **Good News!** Your shipment is currently on its way to the destination.
@elseif($shipmentData['status'] === 'Delivered')
🎉 **Delivered!** Your shipment has been successfully delivered.
@elseif($shipmentData['status'] === 'On Hold')
⚠️ **Attention Required:** Your shipment is currently on hold. Please contact our support team for more information.
@elseif($shipmentData['status'] === 'Customs')
📋 **Customs Processing:** Your shipment is currently being processed by customs authorities.
@elseif($shipmentData['status'] === 'Out for Delivery')
🚚 **Out for Delivery:** Your package is out for delivery and should arrive soon!
@else
📦 **Status Update:** Your shipment status has been updated to "{{ $shipmentData['status'] }}".
@endif

## Track Your Shipment

Stay updated with real-time tracking information by visiting our tracking page with your tracking number: **{{ $shipmentData['trackingnumber'] }}**

@component('mail::button', ['url' => $settings->site_address . '/track-order'])
Track Shipment
@endcomponent

## Contact Information

@if($emailType === 'sender')
**Recipient Details:**
Name: {{ $shipmentData['name'] }}
Email: {{ $shipmentData['email'] }}
Phone: {{ $shipmentData['phone'] }}
Address: {{ $shipmentData['address'] }}, {{ $shipmentData['country'] }}
@else
**Sender Details:**
Name: {{ $shipmentData['sname'] }}
Email: {{ $shipmentData['semail'] }}
Phone: {{ $shipmentData['sphone'] }}
Address: {{ $shipmentData['saddress'] }}, {{ $shipmentData['scountry'] }}
@endif

---

## Important Delivery Information

@if($shipmentData['cost'])
**Shipping Cost:** ${{ $shipmentData['cost'] }}
@endif
@if($shipmentData['clearance_cost'])
**Clearance Cost:** ${{ $shipmentData['clearance_cost'] }}
@endif
@if($shipmentData['qty'])
**Quantity:** {{ $shipmentData['qty'] }} item(s)
@endif

**Important Notes:**
- This is an automated update based on the latest scan of your package
- If you have any questions about this update, please contact our support team
- Delivery times may vary based on location and weather conditions
- For urgent matters, please contact us immediately using the information below

## Need Assistance?

Our customer service team is available to help with any questions about your shipment update.

**Contact Us:**
- **Email:** {{ $settings->contact_email }}
- **Website:** {{ $settings->site_address }}

Thank you for choosing **{{ $settings->site_name }}** for your shipping needs. We appreciate your business and are committed to keeping you informed throughout your shipment's journey.

Best regards,
**{{ $settings->site_name }} Customer Service Team**

---

*This is an automated update notification. Please do not reply directly to this email. For assistance, please contact {{ $settings->contact_email }}*

@endcomponent
