@component('mail::message')
# {{ $emailType === 'sender' ? 'Shipment Pickup Confirmation' : 'Shipment Notification' }}

@if($emailType === 'sender')
Dear **{{ $shipmentData['sname'] }}**,

Thank you for choosing **{{ $settings->site_name }}** for your shipping needs. We are pleased to confirm that your shipment has been successfully processed and is now in our logistics network.
@else
Dear **{{ $shipmentData['name'] }}**,

We are writing to inform you that a shipment addressed to you has been processed through **{{ $settings->site_name }}** and is currently being prepared for delivery.
@endif

## Shipment Details

@component('mail::panel')
**Tracking Number:** {{ $shipmentData['trackingnumber'] }}
**From:** {{ $shipmentData['take_off_point'] ?? $shipmentData['saddress'] }}
**To:** {{ $shipmentData['final_destination'] ?? $shipmentData['address'] }}
**Service Type:** {{ $shipmentData['freight_type'] }}
**Content Type:** {{ $shipmentData['shipment_type'] }}
**Weight:** {{ $shipmentData['weight'] }}
**Current Status:** {{ $shipmentData['status'] }}
**Date Shipped:** {{ \Carbon\Carbon::parse($shipmentData['date_shipped'])->format('M d, Y \a\t h:i A') }}
**Expected Delivery:** {{ \Carbon\Carbon::parse($shipmentData['expected_delivery'])->format('M d, Y \a\t h:i A') }}
@endcomponent

@if($shipmentData['description'])
**Shipment Description:** {{ $shipmentData['description'] }}
@endif

## Track Your Shipment

You can track your shipment in real-time using the tracking number above. Simply visit our tracking page and enter your tracking number: **{{ $shipmentData['trackingnumber'] }}**

@component('mail::button', ['url' => $settings->site_address . '/track-order'])
Track Shipment
@endcomponent

## Contact Information

@if($emailType === 'sender')
**Recipient Details:**
Name: {{ $shipmentData['name'] }}
Email: {{ $shipmentData['email'] }}
Phone: {{ $shipmentData['phone'] }}
Address: {{ $shipmentData['address'] }}, {{ $shipmentData['country'] }}
@else
**Sender Details:**
Name: {{ $shipmentData['sname'] }}
Email: {{ $shipmentData['semail'] }}
Phone: {{ $shipmentData['sphone'] }}
Address: {{ $shipmentData['saddress'] }}, {{ $shipmentData['scountry'] }}
@endif

---

**Important Notes:**
- Please keep your tracking number safe for future reference
- For any inquiries, please contact us at {{ $settings->contact_email }}
- Delivery times may vary based on location and weather conditions
- Ensure someone is available at the delivery address during business hours

## Need Assistance?

Our customer service team is here to help you with any questions or concerns.

**Contact Us:**
- **Email:** {{ $settings->contact_email }}
- **Website:** {{ $settings->site_address }}

Thank you for trusting **{{ $settings->site_name }}** with your shipping needs. We are committed to providing you with reliable and professional courier services.

Best regards,
**{{ $settings->site_name }} Team**

---

*This is an automated message. Please do not reply directly to this email. For assistance, please contact {{ $settings->contact_email }}*

@endcomponent
