



@php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
@endphp
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel ">
        <div class="content card">
            <div class="page-inner card-body ">
                <div class="mt-2 mb-4">
                    <h1 class="title1 text-{{ $text }} text-center">Create A New Shipment</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row d-flex justify-content-center">
                    <div class="col-md-12">
                        <div class="card p-2 shadow ">
                            <div class="card-body">

 <div id="TradingModal" class="modal fade" role="dialog">
     <div class="modal-dialog col-md-12">
         <!-- Modal content-->
         <div class="modal-content">
             <div class="modal-header ">
                 <h4 class="modal-title ">Update shipment status for {{ $user->name }} </h4>
                 <button type="button" class="close " data-dismiss="modal">&times;</button>
             </div>
             <div class="modal-body ">
                 <form role="form" method="post" action="{{ route('addhistory') }}">
                     @csrf

                     <div class="form-group">
                        <h5 class=" ">New Location Address</h5>
                        <input type="text" name="address" class="form-control" placeholder='New Location Address' required>
                    </div>

                    <div class="form-group">
                        <h5 class=" ">New Location City </h5>
                        <input type="text" name="city" class="form-control" placeholder='New Location City' required>
                    </div>
                     <div class="form-group">
                         <h5 class=" ">New Location Country</h5>
                         <select class="form-control  " name="country"  placeholder='New Location Country' required>
                            <option value="" selected disabled>Select Country</option>

                            @include('auth.countries')
                         </select>
                     </div>

                     <div class="form-group">
                         <h5 class=" ">New Status</h5>
                         <select class="form-control  " name="status" required>
                             <option value="" selected disabled>Select New Status</option>
                             <option data-value="Approved ">Approved </option>
                                                                <option data-value="Available">Available</option>
                                                                <option data-value="Cancelled">Cancelled</option>
                                                                <option data-value="Customs">Customs</option>
                                                                <option data-value="Delivered">Delivered</option>
                                                                <option data-value="Dispenser">Dispenser</option>
                                                                <option data-value="Distribution">Distribution</option>
                                                                <option data-value="Earring Collection">Earring Collection</option>
                                                                <option data-value="Effective">Effective</option>
                                                                <option data-value="In Transit">In Transit</option>
                                                                <option data-value="In warehouse">In warehouse</option>
                                                                <option data-value="Invoiced">Invoiced</option>
                                                                <option data-value="On Hold">On Hold</option>
                                                                <option data-value="On route">On route</option>
                                                                <option data-value="Packaged">Packaged</option>
                                                                <option data-value="Pending">Pending</option>
                         </select>
                     </div>

                     <div class="form-group">
                        <h5 class=" ">Delivery Percentage Complete </h5>
                        <input type="number" name="percentage_complete" class="form-control" placeholder=' Delivery Percentage Complete' required>
                    </div>

                     <div class="form-group col-md-12">
                        <h5 class="text-{{$text}}"> Comment</h5>
                        <textarea class="form-control bg-{{$bg}} text-{{$text}}  input-lg" name="comment" rows="2" cols="2"> </textarea>
                        {{-- <input type="text" class="form-control bg-{{$bg}} text-{{$text}}  input-lg"  id="inputlg"  name="sphone"  placeholder="Sender Phone Number" required> --}}
                    </div>
                     <div class="form-group">
                         <input type="submit" class="btn btn-primary" value="Update History">
                         <input type="hidden" name="user_id" value="{{ $user->id }}">
                     </div>
                 </form>
             </div>
         </div>
     </div>
 </div>

 @endsection
