<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
<div class="container py-8 max-w-2xl mx-auto">
    <h1 class="text-2xl font-bold mb-6">Edit Shipment</h1>
    @if($errors->any())
        <div class="bg-red-100 text-red-800 p-3 rounded mb-4">
            <ul class="list-disc pl-5">
                @foreach($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    <form method="POST" action="{{ route('admin.shipments.update', $shipment->id) }}">
        @csrf
        @method('PUT')
        <div class="mb-4">
            <label class="block font-medium mb-1">Tracking Number</label>
            <input type="text" name="trackingnumber" class="w-full border rounded px-3 py-2" value="{{ old('trackingnumber', $shipment->trackingnumber) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Sender Name</label>
            <input type="text" name="sender_name" class="w-full border rounded px-3 py-2" value="{{ old('sender_name', $shipment->sender_name) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Sender Address</label>
            <input type="text" name="sender_address" class="w-full border rounded px-3 py-2" value="{{ old('sender_address', $shipment->sender_address) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Sender Email</label>
            <input type="email" name="sender_email" class="w-full border rounded px-3 py-2" value="{{ old('sender_email', $shipment->sender_email) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Sender Phone</label>
            <input type="text" name="sender_phone" class="w-full border rounded px-3 py-2" value="{{ old('sender_phone', $shipment->sender_phone) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Receiver Name</label>
            <input type="text" name="receiver_name" class="w-full border rounded px-3 py-2" value="{{ old('receiver_name', $shipment->receiver_name) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Receiver Address</label>
            <input type="text" name="receiver_address" class="w-full border rounded px-3 py-2" value="{{ old('receiver_address', $shipment->receiver_address) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Receiver Email</label>
            <input type="email" name="receiver_email" class="w-full border rounded px-3 py-2" value="{{ old('receiver_email', $shipment->receiver_email) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Receiver Phone</label>
            <input type="text" name="receiver_phone" class="w-full border rounded px-3 py-2" value="{{ old('receiver_phone', $shipment->receiver_phone) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Origin</label>
            <input type="text" name="origin" class="w-full border rounded px-3 py-2" value="{{ old('origin', $shipment->origin) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Destination</label>
            <input type="text" name="destination" class="w-full border rounded px-3 py-2" value="{{ old('destination', $shipment->destination) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Shipment Type</label>
            <input type="text" name="shipment_type" class="w-full border rounded px-3 py-2" value="{{ old('shipment_type', $shipment->shipment_type) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Freight Type</label>
            <input type="text" name="freight_type" class="w-full border rounded px-3 py-2" value="{{ old('freight_type', $shipment->freight_type) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Weight</label>
            <input type="text" name="weight" class="w-full border rounded px-3 py-2" value="{{ old('weight', $shipment->weight) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Date Shipped</label>
            <input type="date" name="date_shipped" class="w-full border rounded px-3 py-2" value="{{ old('date_shipped', $shipment->date_shipped) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Expected Delivery</label>
            <input type="date" name="expected_delivery" class="w-full border rounded px-3 py-2" value="{{ old('expected_delivery', $shipment->expected_delivery) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Status</label>
            <input type="text" name="status" class="w-full border rounded px-3 py-2" value="{{ old('status', $shipment->status) }}" required>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Description</label>
            <textarea name="description" class="w-full border rounded px-3 py-2">{{ old('description', $shipment->description) }}</textarea>
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Photo (URL or path)</label>
            <input type="text" name="photo" class="w-full border rounded px-3 py-2" value="{{ old('photo', $shipment->photo) }}">
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Location</label>
            <input type="text" name="location" class="w-full border rounded px-3 py-2" value="{{ old('location', $shipment->location) }}">
        </div>
        <div class="mb-4">
            <label class="block font-medium mb-1">Percentage Complete</label>
            <input type="number" name="percentage_complete" class="w-full border rounded px-3 py-2" min="0" max="100" value="{{ old('percentage_complete', $shipment->percentage_complete) }}">
        </div>
        <button type="submit" class="bg-primary text-white px-4 py-2 rounded">Update Shipment</button>
    </form>
</div>
@endsection
