<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddMissingColumnsToShipmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('shipments', function (Blueprint $table) {
            if (!Schema::hasColumn('shipments', 'addresslocation')) {
                $table->string('addresslocation')->nullable();
            }
            if (!Schema::hasColumn('shipments', 'cost')) {
                $table->decimal('cost', 10, 2)->nullable();
            }
            if (!Schema::hasColumn('shipments', 'clearance_cost')) {
                $table->decimal('clearance_cost', 10, 2)->nullable();
            }
            if (!Schema::hasColumn('shipments', 'qty')) {
                $table->integer('qty')->nullable();
            }
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('shipments', function (Blueprint $table) {
            $table->dropColumn(['addresslocation', 'cost', 'clearance_cost', 'qty']);
        });
    }
}
