<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;
use App\Models\QuoteRequest;
use App\Models\Settings;

class QuoteRequestReceived extends Mailable
{
    use Queueable, SerializesModels;

    public $quoteRequest;
    public $settings;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct(QuoteRequest $quoteRequest, Settings $settings)
    {
        $this->quoteRequest = $quoteRequest;
        $this->settings = $settings;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.quote-request-received')
                    ->subject('New Quote Request - ' . $this->quoteRequest->reference_number)
                    ->with([
                        'quoteRequest' => $this->quoteRequest,
                        'settings' => $this->settings,
                    ]);
    }
}
